#version 330
#extension GL_EXT_gpu_shader4 : enable
// fake water caustics v2Mod01.fsh  by   Emil 

//https://www.shadertoy.com/view/XdlBWN
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float timeSpeed = 2.0;

float randomVal (float inVal)
{
    return fract(sin(dot(vec2(inVal, 2523.2361) ,vec2(12.9898,78.233))) * 43758.5453)-0.5;
}

vec2 randomVec2 (float inVal)
{
    return normalize(vec2(randomVal(inVal), randomVal(inVal+151.523)));
}

float makeWaves(vec2 uv, float theTime, float offset)
{
    float result = 0.0;
    float direction = 0.0;
    float sineWave = 0.0;
    vec2 randVec = vec2(1.0,0.0);
    float i;
    for(int n = 0; n < 16; n++)
    {
        i = float(n)+offset;
        randVec = randomVec2(float(i));
  		direction = (uv.x*randVec.x+uv.y*randVec.y);
        sineWave = sin(direction*randomVal(i+1.6516)+theTime*timeSpeed);
        sineWave = smoothstep(0.0,1.0,sineWave);
    	result += randomVal(i+123.0)*sineWave;
    }
    return result;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.x;
    
    vec2 uv2 = uv * 150.0; // scale
    
    uv *= 2.0;
    
    float result = 0.0;
    float result2 = 0.0;
    
    result = makeWaves( uv2, iTime, 0.1);
    result2 = makeWaves( uv2, iTime*0.8+0.06, 0.26);
    
    //result *= 2.6;
    
    result = smoothstep(0.8,1.0,1.0-abs(result));
    result2 = smoothstep(0.8,1.0,1.0-abs(result2));
    
    result = smoothstep(0.0,1.0,(result+result2)*0.5);
    
	gl_FragColor = vec4(result)*0.7+texture2D( iChannel0 , uv );
}
